import nuke
import os
import webbrowser
import beeble

# Add to the Nodes menu (left sidebar)
toolbar = nuke.menu("Nodes")


custom_menu = toolbar.addMenu(
    "Beeble", icon=os.path.join(os.path.dirname(__file__), "icon.png")
)
custom_menu.addCommand("Load PBR Passes", "beeble.load_pbr_passes()")
custom_menu.addSeparator()

# Lights submenu
lights_menu = custom_menu.addMenu("Lights")
lights_menu.addCommand("Beeble Point Light", "beeble.add_point_light()")
lights_menu.addCommand("Beeble Directional Light", "beeble.add_directional_light()")
lights_menu.addCommand("Beeble Environment Light", "beeble.add_environment_light()")

# Helpers submenu
helpers_menu = custom_menu.addMenu("Helpers")
helpers_menu.addCommand("PBR Controller", "beeble.add_pbr_controller()")
helpers_menu.addCommand("PBR Packer", "beeble.add_pbr_packer()")

custom_menu.addSeparator()
custom_menu.addCommand("Check for Updates", "beeble.check_for_updates()")
custom_menu.addCommand(
    "Documentation",
    "import webbrowser; webbrowser.open('https://docs.beeble.ai/integration/nuke-plugin')",
)

print(os.path.join(os.path.dirname(__file__), "icon.png"))

# Check for updates on startup (only shows dialog if update available)
beeble.check_for_updates_on_startup()
