# init.py - Runs on Nuke startup before menu.py
# Adds gizmos directory to Nuke's plugin path so gizmos can reference each other by name

# ============================================================================
# STAGED UPDATE APPLICATION
# Must run BEFORE any beeble imports to avoid file lock issues
# ============================================================================
import os
import shutil

plugin_dir = os.path.dirname(__file__)
staging_dir = os.path.join(plugin_dir, "_update_staging")

if os.path.exists(staging_dir):
    try:
        # Apply staged update: copy all files from staging to plugin root
        for item in os.listdir(staging_dir):
            src = os.path.join(staging_dir, item)
            dst = os.path.join(plugin_dir, item)

            # Remove existing file/directory
            if os.path.exists(dst):
                if os.path.isdir(dst):
                    shutil.rmtree(dst)
                else:
                    os.remove(dst)

            # Copy from staging
            if os.path.isdir(src):
                shutil.copytree(src, dst)
            else:
                shutil.copy2(src, dst)

        # Remove staging directory after successful update
        shutil.rmtree(staging_dir)
        print("[Beeble] Plugin updated successfully!")
    except Exception as e:
        print("[Beeble] Failed to apply staged update: {}".format(e))

# ============================================================================
# NORMAL INITIALIZATION
# ============================================================================
import nuke

# Add the gizmos directory to Nuke's plugin path
gizmos_dir = os.path.join(plugin_dir, "gizmos")
nuke.pluginAddPath(gizmos_dir)
