# beeble/utils.py
"""Utility functions."""

import math


def kelvin_to_rgb(temperature):
    """
    Convert color temperature in Kelvin to RGB values.

    Args:
        temperature: Color temperature in Kelvin (1000-12000)

    Returns:
        Tuple of (r, g, b) values normalized to 0.0-1.0
    """
    temp_norm = temperature / 100.0

    # Calculate red
    if temp_norm <= 66:
        r = 1.0
    else:
        r = max(
            0.0, min(1.0, (329.698727446 * pow(temp_norm - 60, -0.1332047592)) / 255.0)
        )

    # Calculate green
    if temp_norm <= 66:
        g = max(
            0.0,
            min(1.0, (99.4708025861 * math.log(temp_norm) - 161.1195681661) / 255.0),
        )
    else:
        g = max(
            0.0, min(1.0, (288.1221695283 * pow(temp_norm - 60, -0.0755148492)) / 255.0)
        )

    # Calculate blue
    if temp_norm >= 66:
        b = 1.0
    elif temp_norm <= 19:
        b = 0.0
    else:
        b = max(
            0.0,
            min(
                1.0,
                (138.5177312231 * math.log(temp_norm - 10) - 305.0447927307) / 255.0,
            ),
        )

    return (r, g, b)
