# beeble/__init__.py
"""
Beeble - Nuke addon for loading PBR passes and relighting.

Public API:
    - load_pbr_passes(): Load PBR passes from a folder
    - add_directional_light(): Add a directional light gizmo
    - add_point_light(): Add a point light gizmo
    - add_environment_light(): Add an environment light gizmo (HDRI-based IBL)
    - add_pbr_controller(): Add a PBR controller gizmo
    - add_pbr_packer(): Add a PBR packer gizmo
    - check_for_updates(): Check for plugin updates
"""

__version__ = "0.3.4"
__release_notes__ = "Support Nuke 14.1v2."
__min_nuke_version__ = "14.1v2"

# Public API
from .loaders import load_pbr_passes, add_pbr_controller, add_pbr_packer
from .lighting import (
    add_directional_light,
    add_point_light,
    add_environment_light,
)
from .update_checker import check_for_updates, check_for_updates_on_startup

__all__ = [
    "__version__",
    "__release_notes__",
    "__min_nuke_version__",
    "load_pbr_passes",
    "add_directional_light",
    "add_point_light",
    "add_environment_light",
    "add_pbr_controller",
    "add_pbr_packer",
    "check_for_updates",
    "check_for_updates_on_startup",
]
