# CLAUDE.md

This file provides guidance to Claude Code (claude.ai/code) when working with code in this repository.

## Project Overview

Beeble Nuke Addon is a Nuke plugin for PBR (Physically Based Rendering) relighting and image-based lighting (IBL). It provides tools for loading PBR passes, adding dynamic lights (directional, point, environment), and processing HDRI environments using GPU-accelerated Blink kernels.

**Requirements:** Nuke 14.1v5 or higher

## Build Commands

**Regenerate HDRIProcessor gizmo** (required after modifying `blinkscripts/SphericalBlur.blink`):
```bash
python scripts/build_hdri_processor.py
```

This embeds the SphericalBlur kernel into `gizmos/HDRIProcessor.gizmo`.

## Release Process

Releases are automated via GitHub Actions when pushing to `release/prod`:

1. Update version metadata in `beeble/__init__.py`:
   - `__version__` - semantic version (e.g., "0.3.3")
   - `__release_notes__` - description for this release
   - `__min_nuke_version__` - minimum Nuke version required

2. Push to `release/prod` branch - the workflow will:
   - Create versioned ZIP and upload to S3
   - Update `latest.json` and `latest.zip`
   - Create and push a git tag

## Architecture

### Entry Points (Nuke Plugin Loading)

- `init.py` - Runs first on Nuke startup. Handles staged updates from auto-updater, adds gizmos to plugin path
- `menu.py` - Runs after init. Creates "Beeble" menu in Nodes toolbar, triggers startup update check

### Core Modules (`beeble/`)

- `__init__.py` - Public API and version metadata (source of truth for CI/CD)
- `loaders.py` - PBR pass loading from multi-layer EXR, PNG/EXR subfolders, or MP4 video files
- `lighting.py` - Light gizmo creation (directional, point, environment) with temperature-based color control
- `update_checker.py` - Auto-update system that downloads updates to `_update_staging/` and applies on restart
- `utils.py` - Utility functions (Kelvin to RGB conversion)

### GPU Kernels (`blinkscripts/`)

Blink kernels for GPU-accelerated rendering:
- `DirectionalLight.blink` / `PointLight.blink` - GGX specular relighting
- `IBLLight.blink` - Image-based lighting with roughness-dependent sampling
- `SphericalBlur.blink` - Spherical Gaussian blur for HDRI preprocessing (embedded into HDRIProcessor.gizmo via build script)

### Gizmos (`gizmos/`)

Pre-built Nuke node groups. `HDRIProcessor.gizmo` is generated by the build script - do not edit directly.

## Key Implementation Details

- Version metadata in `beeble/__init__.py` is parsed by GitHub Actions workflow using grep
- Auto-updater uses `_update_staging/` directory for safe updates between Nuke restarts
- All gizmo loading uses absolute paths from `os.path.dirname(__file__)` to avoid path issues
- SSL context has disabled cert verification for Nuke compatibility
- Python 2.7/3.x compatible (urllib fallback for Python 2)
