from bpy.utils import register_class, unregister_class

from .account_operators import (
    BEEBLE_OT_BrowserLogin,
    BEEBLE_OT_CancelLogin,
    BEEBLE_OT_Logout,
    BEEBLE_OT_EmptyWorkspace,
    BEEBLE_OT_CheckForUpdates,
    BEEBLE_OT_DownloadUpdate,
    BEEBLE_OT_QuitBlender,
)
from .utility_operators import (
    BEEBLE_OT_SwitchTab,
    BEEBLE_OT_OpenWebUrl,
    BEEBLE_OT_InfoAlert,
    BEEBLE_OT_ErrorAlert,
)
from .shot_operators import (
    BEEBLE_OT_ImportShot,
    BEEBLE_OT_ChooseShotDirectory,
    BEEBLE_OT_RemoveShotFromScene,
    BEEBLE_OT_ActiveShot,
    BEEBLE_OT_ShotExportSettings,
    BEEBLE_OT_ImportSettingsConflictDialog,
)
from .edit_operators import (
    BEEBLE_OT_EditShot,
    BEEBLE_OT_ToogleShotVisibility,
    BEEBLE_OT_CloseShotDetails,
    BEEBLE_OT_ClearResolution,
    BEEBLE_OT_ClearFrame,
)

# Create a list of all classes to register
classes = [
    # Account operators
    BEEBLE_OT_BrowserLogin,
    BEEBLE_OT_CancelLogin,
    BEEBLE_OT_Logout,
    BEEBLE_OT_EmptyWorkspace,
    BEEBLE_OT_CheckForUpdates,
    BEEBLE_OT_DownloadUpdate,
    BEEBLE_OT_QuitBlender,

    # Utility operators
    BEEBLE_OT_OpenWebUrl,
    BEEBLE_OT_SwitchTab,
    BEEBLE_OT_InfoAlert,
    BEEBLE_OT_ErrorAlert,

    # Shot operators
    BEEBLE_OT_ImportShot,
    BEEBLE_OT_ChooseShotDirectory,
    BEEBLE_OT_RemoveShotFromScene,
    BEEBLE_OT_ActiveShot,
    BEEBLE_OT_ShotExportSettings,
    BEEBLE_OT_ImportSettingsConflictDialog,

    # Edit operators
    BEEBLE_OT_EditShot,
    BEEBLE_OT_ToogleShotVisibility,
    BEEBLE_OT_CloseShotDetails,
    BEEBLE_OT_ClearResolution,
    BEEBLE_OT_ClearFrame,
]

def register():
    """Register operator classes"""
    for cls in classes:
        register_class(cls)

def unregister():
    """Unregister operator classes"""
    for cls in reversed(classes):
        unregister_class(cls)

if __name__ == "__main__":
    register()