import os
import bpy
from bpy.utils import previews

from . import properties
from . import operators
from . import panels

# Global preview collections dictionary
preview_collections = {}
custom_icons = None

def register():
    """Register all interface components"""
    # Register property classes and create scene properties
    properties.register()

    # Register operator classes
    operators.register()

    # Register panel classes
    panels.register()

    global custom_icons
    custom_icons = previews.new()

    # Get the path to your icon file
    icons_dir = os.path.join(os.path.dirname(__file__), "icons")
    # Load the icon
    custom_icons.load("custom_error", os.path.join(icons_dir, "ic_beeble_error.png"), 'IMAGE')


def unregister():
    """Unregister all interface components"""
    # Unregister UI components in reverse order
    try:
        panels.unregister()
    except Exception as e:
        print(f"Warning: Error unregistering panels: {e}")

    try:
        operators.unregister()
    except Exception as e:
        print(f"Warning: Error unregistering operators: {e}")

    try:
        properties.unregister()
    except Exception as e:
        print(f"Warning: Error unregistering properties: {e}")

    global custom_icons
    custom_icons.clear()
    previews.remove(custom_icons)

    print("Beeble: Interface unregistration complete")

# Optional: Development utility for debugging
def reload_modules():
    """Reload all interface modules (useful during development)"""
    import importlib

    modules = [properties, operators, panels]

    for module in modules:
        importlib.reload(module)

    print("Beeble: Interface modules reloaded")