# custom_icon_manager.py
import bpy
import os
from bpy.utils import previews

class CustomIconManager:
    def __init__(self):
        self._custom_icons = None

    def load_icons(self, icons_dir):
        """Load all icons from the specified directory"""
        if self._custom_icons is None:
            self._custom_icons = previews.new()

        # Check if directory exists
        if not os.path.exists(icons_dir):
            print(f"Icons directory not found: {icons_dir}")
            return

        # Load each icon from the directory
        for filename in os.listdir(icons_dir):
            if filename.endswith(".png"):
                icon_name = os.path.splitext(filename)[0]
                print(f"Loading icon: {icon_name}")
                if icon_name not in self._custom_icons:
                    filepath = os.path.join(icons_dir, filename)
                    self._custom_icons.load(icon_name, filepath, 'IMAGE')

    def get_icon_id(self, icon_name):
        """Get icon ID for the given icon name"""
        if self._custom_icons and icon_name in self._custom_icons:
            return self._custom_icons[icon_name].icon_id
        return 0  # Return 0 if icon not found

    def clear_icons(self):
        """Remove all loaded icons"""
        if self._custom_icons is not None:
            previews.remove(self._custom_icons)
            self._custom_icons = None

# Create a singleton instance
icon_manager = CustomIconManager()