import math
import mathutils
from enum import Enum
from bpy_extras.io_utils import axis_conversion

WEBSITE_URL = "https://beeble.ai"
AUTH_SIGNIN_URL = "https://app.beeble.ai/signin"
AUTH_SIGNOUT_URL = "https://app.beeble.ai/signout"
API_URL = "https://api.beeble.ai"

# Define tab configurations
TAB_CONFIG = {
    "SHOTS": {
        "label": "Edit & Render",
        "icon": "OPTIONS",
        "description": "Edit and Render VFX Passes",
    },
    "SETTING": {
        "label": "Account & Settings",
        "icon": "USER",
        "description": "View account information and settings",
    },
}

ITEMS_PER_PAGE = 4
NUM_SHOTS_PER_ROW = 2
NUM_SETS_PER_ROW = 2

# Constants that might be used across multiple core modules

# Update URLs for latest.json and latest.zip
LATEST_JSON_URL = "https://release.beeble.ai/plugins/blender/latest.json"
LATEST_ZIP_URL = "https://release.beeble.ai/plugins/blender/latest.zip"

UNITY2BLENDER = axis_conversion(
    from_forward="Z", from_up="Y", to_forward="-Y", to_up="Z"
).to_4x4()

IDENTITY_MATRIX = mathutils.Matrix.Identity(4)

ORIENTATION_PORTRAIT = 1
ORIENTATION_UPSIDE_DOWN = 2
ORIENTATION_LANDSCAPE_LEFT = 3
ORIENTATION_LANDSCAPE_RIGHT = 4

RAD_PORTRAIT = math.radians(0)
# Since we locked the device orientation, then the camera is rotated 90 degrees to the left, so we need to rotate the image 90 degrees to the right
# If the device orientation is not locked, then the camera coordinates will be the same as the device coordinates, so we don't need to rotate the image, I guess (not tested)
RAD_UPSIDE_DOWN = math.radians(180)
RAD_LANDSCAPE_LEFT = math.radians(-90)
RAD_LANDSCAPE_RIGHT = math.radians(90)

ROTATE_PORTRAIT = mathutils.Matrix.Rotation(RAD_PORTRAIT, 4, "Z")
ROTATE_UPSIDE_DOWN = mathutils.Matrix.Rotation(RAD_UPSIDE_DOWN, 4, "Z")
ROTATE_LANDSCAPE_LEFT = mathutils.Matrix.Rotation(RAD_LANDSCAPE_LEFT, 4, "Z")
ROTATE_LANDSCAPE_RIGHT = mathutils.Matrix.Rotation(RAD_LANDSCAPE_RIGHT, 4, "Z")


class SetStatus(str, Enum):
    UPDATING = "updating"
    IN_RENDER = "in_render"
    READY = "ready"


# Handle other errors
UNK_ERROR_MSG = "Unknown error occurred"
