import importlib

from . import api
from . import constants
from . import helpers
from . import logger
from . import shot_utils
from . import icon_manager

# List of modules for reloading
modules = (
    api,
    constants,
    helpers,
    logger,
    shot_utils,
    icon_manager,
)

def reload_modules():
    """Reload all core modules (useful during development)"""
    for module in modules:
        importlib.reload(module)
    print("Beeble: Core modules reloaded")

def register():
    """Register core functionality"""
    reload_modules()  # For development
    print("Beeble: Core registration complete")

def unregister():
    """Unregister core functionality"""
    print("Beeble: Core unregistration complete")
